/*-----------------------------------------------------------------------*/
/* Low level disk I/O module skeleton for FatFs     (C)ChaN, 2016        */
/*-----------------------------------------------------------------------*/
/* If a working storage control module is available, it should be        */
/* attached to the FatFs via a glue function rather than modifying it.   */
/* This is an example of glue functions to attach various exsisting      */
/* storage control modules to the FatFs module with a defined API.       */
/*-----------------------------------------------------------------------*/

#include "diskio.h"		/* FatFs lower layer API */
#include "integer.h"
#include "bsp_micro_sd.h"

/* Definitions of physical drive number for each drive */
#define SDCard		0	/* Example: Map ATA harddisk to physical drive 0 */
#define USB		1	/* Example: Map USB MSD to physical drive 1 */

static  DRESULT SDCard_disk_status(void);
static  DRESULT SDCard_disk_initialize(void);
static  DRESULT SDCard_disk_read(BYTE *buff, DWORD sector, UINT count);
static  DRESULT SDCard_disk_write(const BYTE *buff, DWORD sector, UINT count);
static  DRESULT SDCard_disk_ioctl(void *buff, BYTE cmd);
/*-----------------------------------------------------------------------*/
/* Get Drive Status                                                      */
/*-----------------------------------------------------------------------*/

DSTATUS disk_status (
	BYTE pdrv		/* Physical drive nmuber to identify the drive */
)
{
	DSTATUS stat;

	switch (pdrv) {
	case SDCard :
		stat = SDCard_disk_status();

		// translate the reslut code here

		return stat;

	case USB :

		// translate the reslut code here

		return stat;
	}
	return STA_NOINIT;
}

/*-----------------------------------------------------------------------*/
/* Inidialize a Drive                                                    */
/*-----------------------------------------------------------------------*/

DSTATUS disk_initialize (
	BYTE pdrv				/* Physical drive nmuber to identify the drive */
)
{
	DSTATUS stat;

	switch (pdrv) {
	case SDCard :
		stat = SDCard_disk_initialize();

		// translate the reslut code here

		return stat;

	case USB :

		// translate the reslut code here

		return stat;
	}
	return STA_NOINIT;
}



/*-----------------------------------------------------------------------*/
/* Read Sector(s)                                                        */
/*-----------------------------------------------------------------------*/

DRESULT disk_read (
	BYTE pdrv,		/* Physical drive nmuber to identify the drive */
	BYTE *buff,		/* Data buffer to store read data */
	DWORD sector,		/* Start sector in LBA */
	UINT count		/* Number of sectors to read */
)
{
	DRESULT res;

	switch (pdrv) {
	case SDCard :
		// translate the arguments here

		res = SDCard_disk_read(buff, sector, count);

		// translate the reslut code here

		return res;

	case USB :
		// translate the arguments here

		// translate the reslut code here

		return res;
	}

	return RES_PARERR;
}

/*-----------------------------------------------------------------------*/
/* Write Sector(s)                                                       */
/*-----------------------------------------------------------------------*/

DRESULT disk_write (
	BYTE pdrv,			/* Physical drive nmuber to identify the drive */
	const BYTE *buff,	/* Data to be written */
	DWORD sector,		/* Start sector in LBA */
	UINT count			/* Number of sectors to write */
)
{
	DRESULT res;

	switch (pdrv) {
	case SDCard :
		// translate the arguments here

		res = SDCard_disk_write(buff, sector, count);

		// translate the reslut code here

		return res;

	case USB :
		// translate the arguments here


		// translate the reslut code here

		return res;
	}

	return RES_PARERR;
}

/*-----------------------------------------------------------------------*/
/* Miscellaneous Functions                                               */
/*-----------------------------------------------------------------------*/

DRESULT disk_ioctl (
	BYTE pdrv,		/* Physical drive nmuber (0..) */
	BYTE cmd,		/* Control code */
	void *buff		/* Buffer to send/receive control data */
)
{
	DRESULT res;

	switch (pdrv) {
	case SDCard :

		// Process of the command for the ATA drive
		res = SDCard_disk_ioctl(buff, cmd);
		return res;
	case USB :

		// Process of the command the USB drive

		return res;
	}

	return RES_PARERR;
}



/**
  * @brief  SDCard_disk_initialize function
  * @retval Status
  */
DRESULT SDCard_disk_initialize(void)
{
	if(!bsp_sd_init()) {
		return RES_OK;
	}
	else {
		return RES_NOTRDY;
	}
}

/**
  * @brief  SDCard_disk_status function
  * @retval Status
  */
DRESULT SDCard_disk_status(void)
{
	return RES_OK;
}

/**
  * @brief  SDCard_disk_write function
  * @retval Status
  */
DRESULT SDCard_disk_write(const BYTE *buff, DWORD sector, UINT count)
{
	if (!count)
		return RES_PARERR; 

	if (count == 1) {
		if (!bsp_sd_write_sector((BYTE *)buff, sector)) {
			return RES_OK;
		}
		else {
			return RES_ERROR;
		}
	}
	else {

	}

	return RES_OK;
}

/**
  * @brief  SDCard_disk_read function
  * @retval Status
  */
DRESULT SDCard_disk_read(BYTE *buff, DWORD sector, UINT count)
{
	if (!count)
		return RES_PARERR; 

	if (count == 1) {
		if (!bsp_sd_read_sector(buff, sector)) {
			return RES_OK;
		}
		else {
			return RES_ERROR;
		}
	}
	else {

	}

	return RES_OK;
}

/**
  * @brief  SDCard_disk_ioctl function
  * @param  cmd Control code
  * @param  buff  Buffer to send/receive control data
  * @retval Status
  */
DRESULT SDCard_disk_ioctl(void *buff, BYTE cmd)
{
	switch (cmd)
	{
		case CTRL_SYNC :
			return RES_OK;
		case GET_SECTOR_COUNT :
			*(DWORD*)buff = bsp_sd_get_size() / SECTOR_SIZE;
		return RES_OK;
		case GET_BLOCK_SIZE :
			*(WORD*)buff = SECTOR_SIZE;
		return RES_OK;        
		case CTRL_POWER :
			break;
		case CTRL_LOCK :
			break;
		case CTRL_EJECT :
			break;
	
		case MMC_GET_TYPE :
			break;
		case MMC_GET_CSD :
			break;
		case MMC_GET_CID :
			break;
		case MMC_GET_OCR :
			break;
		case MMC_GET_SDSTAT :
			break;        
	}

	return RES_OK;
}

