/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

#define START_THREAD_PRIORITY   25
#define START_THREAD_STACK_SIZE 1024
#define START_THREAD_TIMESLICE  10

#define LED_THREAD_PRIORITY   26
#define LED_THREAD_STACK_SIZE 512
#define LED_THREAD_TIMESLICE  10

#define KEY_THREAD_PRIORITY   24
#define KEY_THREAD_STACK_SIZE 512
#define KEY_THREAD_TIMESLICE  10

/* Thread handlers */
static rt_thread_t led_thread  = RT_NULL;
static rt_thread_t key_thread  = RT_NULL;
static rt_thread_t start_thread = RT_NULL;

/* Event */

/* Thread functions */
static void app_start_thread_entry(void* parameter);
static void app_led_thread_entry(void * parameter);
static void app_key_thread_entry(void * parameter);
static void app_thread_create (void);
static void app_obj_create (void);

#define KEY3_EVENT (0x01 << 1)

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	start_thread = rt_thread_create("start_thread",
                                          app_start_thread_entry, 
	                                  RT_NULL,
                                          START_THREAD_STACK_SIZE,
                                          START_THREAD_PRIORITY, 
	                                  START_THREAD_TIMESLICE);
	if (start_thread != RT_NULL)
		rt_thread_startup(start_thread);
	
	return RT_EOK;
}

/**
  * @brief  LED thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_led_thread_entry(void* parameter)
{
	while(1) {
		bsp_led_toggle(3);
		bsp_led_toggle(2);
		rt_thread_mdelay(300);
	}
}

/**
  * @brief  Key thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_key_thread_entry(void* parameter)
{
	uint8_t keyval = 0;
	
	bsp_key_init();
	while(1) {
		keyval = bsp_get_key();
		if (keyval != KEY_NONE) {
			switch (keyval) {
			case KEY_DOWN_K3:
				rt_kprintf("K3 pressed down\r\n");
				break;
			case KEY_UP_K3:
				rt_kprintf("K3 pressed up\r\n");
				break;
			case KEY_LONG_K3:
				rt_kprintf("K3 long pressed\r\n");
				break;
			default:
				break;
			}
		}
		rt_thread_mdelay(10);
	}
}

/**
  * @brief  System start entry function
  * @param  parameter: Pointer to user's parameter
  * @retval None
  */
static void app_start_thread_entry(void* parameter)
{
	bsp_lcd_init();
	bsp_touch_init();
	bsp_led_init();
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "Rt-thread Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 320, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 320, 24, 16, "->Press K3 to print key state\r\n");
	/* Create semaphore\mutex\event and so on */
	app_obj_create();
	/* Create threads */
	app_thread_create();
	
	while (1) {
		bsp_key_scan();
		rt_thread_mdelay(10);
	}
}

/**
  * @brief  System object create function
  * @retval None
  */
static void app_obj_create(void)
{
	/* Create Samepher \ Event */
}

/**
  * @brief  System thread create function
  * @retval None
  */
static void app_thread_create (void)
{
	led_thread = rt_thread_create("led_thread",
                                          app_led_thread_entry, 
	                                  RT_NULL,
                                          LED_THREAD_STACK_SIZE,
                                          LED_THREAD_PRIORITY, 
	                                  LED_THREAD_TIMESLICE);
	if (led_thread != RT_NULL)
		rt_thread_startup(led_thread);
  
	key_thread = rt_thread_create("key_thread",
                                          app_key_thread_entry, 
	                                  RT_NULL,
                                          KEY_THREAD_STACK_SIZE,
                                          KEY_THREAD_PRIORITY, 
	                                  KEY_THREAD_TIMESLICE);
	if (key_thread != RT_NULL)
		rt_thread_startup(key_thread);
}





