/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/* Test Buffer */
BYTE work[FF_MAX_SS]; 
BYTE ReadBuffer[1024]= {0}; 
BYTE WriteBuffer[] = "EastSoft IC";

/**
  * @brief  SdCard test function
  * @retval None
  */
void sdcard_test_entry(void);

/**
  * @brief  Systick tick callback function
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	static uint8_t cnt = 0;
	cnt++;
	
	if(cnt == 10) {
		cnt = 0;
		bsp_key_scan();
	}
	
	return;
}

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	uint8_t keycode;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Initialize peripherals */
	bsp_led_init();
	bsp_key_init();
	bsp_uart_init();
	bsp_lcd_init();
	bsp_touch_init();
	/* Display */
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "SdCard Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 320, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 320, 24, 16, "->Press K3 to Write/Read SDCard\r\n");
	
	while(1) {
		keycode = bsp_get_key();
		if (keycode != KEY_NONE) {
			switch (keycode) {
			case KEY_DOWN_K3:
				lcd_show_string(30, 220, 320, 24, 16, "                      \r\n");
				lcd_show_string(30, 260, 320, 24, 16, "                      \r\n");
				sdcard_test_entry();	
				break;	
			default:
				break;
			}
		}
	}
}

/**
  * @brief  SdCard test function
  * @retval None
  */


void sdcard_test_entry(void)
{
	FIL fil;            
	FATFS fs;           
	FRESULT rs;
	UINT num;
	
	rs = f_mount(&fs, "0:", 1);
	if (rs == FR_NO_FILESYSTEM) {
		printf("\r\n SDCard have no filesystem.\r\n");
		rs = f_mkfs("0:", 0, 0, work, sizeof(work));

		if (rs == FR_OK) {
			printf("SDCard format successfully.\r\n");
			rs = f_mount(NULL,"0:",1);
			rs = f_mount(&fs,"0:",1);
		} else {
			printf("SDCard format fail.\r\n");
			lcd_show_string(30, 220, 320, 24, 16, "->SDCard format fail\r\n");
		}
	} else if (rs != FR_OK) {
		printf("!! SD mount fail(%d)\r\n",rs);
		lcd_show_string(30, 220, 320, 24, 16, "->SDCard mount fail\r\n");
	} else {
		printf("SDCard mount successfully.\r\n");
	}
	printf("\r\n------------------ File write test ------------------\r\n");
	rs = f_open(&fil,"fileWR.txt", FA_CREATE_ALWAYS|FA_WRITE);
	if ( rs == FR_OK ) {
		printf("Open test file succuss.\r\n");
		rs = f_write(&fil, WriteBuffer, sizeof(WriteBuffer), &num);
		if (rs == FR_OK) {
			lcd_show_string(30, 220, 320, 24, 16, "->SDCard write success\r\n");
			printf("File write success. Write number: %d\r\n", num);
			printf("Write content: \r\n%s\r\n", WriteBuffer);
		} else {
			printf("!!File write fail: (%d)\n",rs);
			lcd_show_string(30, 220, 320, 24, 16, "->SDCard write fail\r\n");
		}
		
		f_close(&fil);
	} else {
		printf("!!Open/Create file fail. \r\n");
	}
	printf("\r\n------------------ File read test -------------------\r\n");
	rs = f_open(&fil,"fileWR.txt",FA_OPEN_EXISTING|FA_READ);
	if (rs == FR_OK) {
		printf("Open file success.\r\n");
		rs = f_read(&fil, ReadBuffer, sizeof(ReadBuffer), &num);
		if (rs == FR_OK) {
			printf("File read success. Read number: %d\r\n",num);
			printf("Read content: \r\n%s \r\n", ReadBuffer);
			lcd_show_string(30, 260, 320, 24, 16, "->SDCard read success\r\n");
		} else {
			printf("!!File read fail: (%d)\n",rs);
			lcd_show_string(30, 260, 320, 24, 16, "->SDCard read fail\r\n");
		}
	} else {
		printf("!!Open file fail\r\n");
	}
	f_close(&fil);
	f_mount(NULL,"0:",1);
}

