/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/**
  * @brief  Systick tick callback function.
  * @retval Status
  */
void ald_systick_irq_cbk(void)
{
	static uint8_t cnt = 0;
	cnt++;
	
	if(cnt == 10) {
		cnt = 0;
		bsp_key_scan();
	}
	return;
}

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	uint8_t keycode = 0;
	uint32_t i = 0, j = 0;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Enable CAN interrupt */
	ald_mcu_irq_config(CAN0_TX_IRQn, 3, 3,  ENABLE);
	ald_mcu_irq_config(CAN0_RX0_IRQn, 3, 3,  ENABLE);
	/* Initialize peripherals */
	bsp_led_init();
	bsp_key_init();
	bsp_uart_init();
	bsp_lcd_init();
	bsp_touch_init();
	bsp_can_init();
	/* Display */
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "CAN Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 400, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 400, 24, 16, "->Press K3 to send data\r\n");
	ald_can_recv_by_it(&h_can, CAN_RX_FIFO0, &rx_msg);
	
	while(1) {
		if (++j == 0x5ffff) {
			j = 0;
			bsp_led_toggle(3);
		}
		keycode = bsp_get_key();
		if (keycode != KEY_NONE) {
			switch (keycode) { 
			case KEY_DOWN_K3:
				can_send_msg();	
				printf("CAN Send ");
				break;
				
			default: 
				break;
			}
		}
		if (can_flag == 1) {
			can_flag = 0;
			lcd_show_string(30, 220, 320, 24, 16, "->CAN received message\r\n");
			printf("Message:");
			for (i = 0; i < rx_msg.len; ++i) {
				printf("0x%x ",rx_msg.data[i]);
			}
			printf("\r\n");
			lcd_show_string(30, 220, 320, 24, 24, "                         \r\n");
		}
	}
}



