/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/**
  * @brief  System tick callback function
  * @retval Status
  */
void ald_systick_irq_cbk(void)
{
	static uint8_t cnt = 0;
	cnt++;
	
	if(cnt == 10) {
		cnt = 0;
		uart5_frame_monitor(RS485_UART);
		bsp_key_scan();
	}
	
	return;
}

/* Test Buffer */
uint8_t srcbuf[5] = {0};
uint8_t desbuf[256] = {0};

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	static uint8_t cnt = 0;
	uint8_t count = 0;
	uint8_t keycode;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Initialize peripherals */
	bsp_led_init();
	bsp_key_init();
	bsp_uart_init();
	bsp_lcd_init();
	bsp_touch_init();
	/* Display */
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "RS485 Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 320, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 320, 24, 16, "->RS485 loopbak mode\r\n");
	lcd_show_string(30, 220, 320, 24, 16, "->Press K3 to send data\r\n");
	
	while(1) {
		if (uart_get_frame_flag(RS485_UART)) {
			uart_clear_frame_flag(RS485_UART);
			count = uart_get_frame(RS485_UART, desbuf);
			if (count != 0) {
				rs485_send_buf(desbuf, count);
			}
		}
		keycode = bsp_get_key();
		if (keycode != KEY_NONE) {
			switch (keycode) {
			case KEY_DOWN_K3:
				printf("K3 pressed\r\n");
				++cnt;
				memset(srcbuf, cnt, 5);
				rs485_send_buf(srcbuf, 5);
				break;
				
			default: 
				break;
			}
		}
	}
}



