/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/**
  * @brief  System tick callback function
  * @retval Status
  */
void ald_systick_irq_cbk(void)
{
	return;
}

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	uint32_t adcval = 0;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Initialize peripherals */
	bsp_led_init();
	bsp_key_init();;
	bsp_uart_init();
	bsp_lcd_init();
	bsp_touch_init();
	adc_module_init();
	/* Display */
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "ADC Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 320, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 320, 24, 16, "->ADC value:\r\n");
	lcd_set_front_color(BLUE);
	adcval = adc_average();
	lcd_show_number(130, 180, adcval, 4, 16);
	
	while(1) {
		ald_delay_ms(200);
		adcval = adc_average();
		lcd_show_number(130, 180, adcval, 4, 16);
		printf("Adc value is: 0x%x\r\n", adcval);
	}
}



