/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Example DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/**
  * @brief  System tick callback function
  * @retval Status
  */
void ald_systick_irq_cbk(void)
{
	static uint8_t cnt = 0;
	cnt++;
	
	if(cnt == 10) {
		cnt = 0;
		bsp_key_scan();
	}
	
	return;
}

/* Test buffer */
uint8_t srcbuf[5] = {0x01, 0x02, 0x03, 0x04, 0x00};
uint8_t desbuf[5] = {0};

/**
  * @brief  This is main function.
  * @retval Status
  */
int main()
{
	static uint8_t cnt = 0;
	uint8_t keycode;
	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
	/* Initialize peripherals */
	bsp_led_init();
	bsp_key_init();
	bsp_uart_init();
	bsp_lcd_init();
	bsp_touch_init();
	bsp_eeprom_init();
	/* Display */
	lcd_set_front_color(BLUE);
	lcd_show_string(80, 100, 210, 24, 24, "EEPROM Test!\r\n");
	lcd_set_front_color(RED);
	lcd_show_string(30, 140, 320, 24, 16, "->Connect ESLinkII\r\n");
	lcd_show_string(30, 180, 320, 24, 16, "->Press K2 to write data\r\n");
	lcd_show_string(30, 220, 320, 24, 16, "->Press K3 to read data\r\n");
	
	while(1) {
		keycode = bsp_get_key();
		if (keycode != KEY_NONE) {
			switch (keycode) {
			case KEY_DOWN_K2:
				printf("KEY2 is pressed down.\r\n");
				cnt++;
				memset(srcbuf, cnt, 5);
				if (bsp_eeprom_write(0xA2, 0, I2C_MEMADD_SIZE_8BIT, srcbuf, 5) == EEP_OK) {
					printf("Write success ...\r\n");
				} else {
					printf("Write fail ...\r\n");
				}
				break;
			case KEY_DOWN_K3:
				printf("KEY3 is pressed down.\r\n");
				if (bsp_eeprom_read(0xA2, 0, I2C_MEMADD_SIZE_8BIT, desbuf, 5) == EEP_OK) {
					printf("Read success ...\r\n");
					printf("The value is :0x%x 0x%x 0x%x 0x%x 0x%x\r\n", desbuf[0], desbuf[1], desbuf[2], desbuf[3], desbuf[4]);
				} else {
					printf("Read fail ...\r\n");
					}
				break;
			default: 
				break;
			}
		}
	}
}



