/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    07 Nov 2017
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"
#include "utils.h"
#include "ald_cmu.h"
#ifdef ALD_DMA
#include "ald_dma.h"
#endif

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
	/* Added Emergency operation */
	return;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
	/* Added system callback */
	return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
	/* Added debug operation */
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
	ald_inc_tick();
	return;
}

/**
  * @brief  CMU IRQ#4 handler
  * @retval None
  */
void CMU_Handler(void)
{
	ald_cmu_irq_handler();
	return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#9 handler
  * @retval None
  */
void DMA_Handler(void)
{
	ald_dma_irq_handler();
}
#endif

/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void RTC_TSENSE_Handler(void)
{
	
	
	
	return;
}
/**
  * @}
  */

/**
  * @}
  */
