/**
  *********************************************************************************
  *
  * @file    msgq.h
  * @brief   Header file for message queue
  *
  * @version V1.0
  * @date    12 Mar 2020
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#ifndef   __MSGQ_H__
#define   __MSGQ_H__

#include "type.h"
#include "list.h"


#define MSG_POOL_SIZE	1000

typedef struct msgq_s {
	list_head_t list;
	uint32_t nr;
} msgq_t;

typedef struct msg_s {
	list_head_t link;

	uint8_t buf[64];
	uint32_t len;
} msg_t;

typedef struct msg_pool_s {
	list_head_t _free;
	uint32_t nr;
} msg_pool_t;


extern void msg_pool_init(void);
extern msg_t *msg_alloc(void);
extern void msg_free(msg_t *msg);
extern uint32_t msg_size_get(void);
extern void msgq_init(msgq_t * msgq);
extern void msgq_enq(msgq_t *msgq, msg_t *msg);
extern msg_t *msgq_deq(msgq_t *msgq);

#endif
