/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    02 Nov 2020
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include "msgq.h"


#define STATE_DEVICE_NO		0x00
#define STATE_DEVICE_CONN	0x02
#define STATE_DEVICE_READY	0x04
#define STATE_DEVICE_READ	0x08
#define STATE_DEVICE_WRITE	0x10
#define STATE_DEVICE_IDLE	0x20
#define STATE_POWER_FAULT	0x40

#define STATE_BUSY		0x0
#define STATE_USB_TX_CPLT	0x1

typedef struct env_s {
	uint8_t tx_buf[64];
	uint8_t rx_buf[64];
	msgq_t mq;
	volatile uint32_t flag;
	volatile uint8_t printer_status;
} env_t;

extern env_t env;
#endif
