/**
  *********************************************************************************
  *
  * @file    shell.c
  * @brief   shell for debug
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include <rtthread.h>
#include "flow.h"


static uint8_t idx = 0;

void cmd_tx(void)
{
	uint8_t buf[64];

	rt_kprintf("FinSH\n");
	memset(buf, idx, 64);
	flow_send_msg_to_tx_msgq(buf, 64);
	return;
}
MSH_CMD_EXPORT(cmd_tx, test to send message);

void cmd_rx(void)
{
	rt_kprintf("FinSH\n");
	flow_send_msg_to_rx_msgq();
	return;
}
MSH_CMD_EXPORT(cmd_rx, test to receive message);
