/**
  *********************************************************************************
  *
  * @file    msg_parse.c
  * @brief   message parse
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include <rtthread.h>
#include "flow.h"
#include "msg_parse.h"
#include "msg_type.h"


/** @brief Show the message.
  * @param buf: Pointer to the data.
  * @param size: Size of the data.
  * @retval Status.
  */
static void msg_show(uint8_t *buf, uint32_t len)
{
	uint32_t i;

	rt_kprintf("MSG Recv[%d]:\n", len);
	
	for (i = 0; i < len; ++i)
		rt_kprintf("0x%x ", buf[i]);

	rt_kprintf("\n");
	return;
}

/** @brief Parse the message.
  * @param buf: Pointer to the data.
  * @param size: Size of the data.
  * @retval None
  */
void msg_parse(uint8_t *buf, uint32_t len)
{
	msg_header_t *hdr = (msg_header_t *)buf;

#ifdef DEBUG_INFO
	msg_show(buf, len);
#endif
	switch (hdr->type) {
	case TYPE_MSG_PDL_0:
		/* Handle message */
		break;

	case TYPE_MSG_PDL_1:
		/* Handle message */
		break;

	default:
		break;
	}

	return;
}
