/**
  *********************************************************************************
  *
  * @file    msg_type.h
  * @brief   Header file for message type
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef   __MSG_TYPE_H__
#define   __MSG_TYPE_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "type.h"


#define TYPE_MSG_PDL_0		0x00
#define TYPE_MSG_PDL_1		0x01
#define TYPE_MSG_PDL_2		0x02
#define TYPE_MSG_PDL_3		0x03
#define TYPE_MSG_PDL_4		0x04


/* Message Structures */
typedef struct msg_header_s {
	uint8_t type;
	uint8_t len;
} msg_header_t;

typedef struct msg_std_s {
	uint8_t type;
	uint8_t len;
	uint8_t data[4];
	uint8_t checksum;
} __attribute__ ((__packed__)) msg_std_t;

#ifdef __cplusplus
 extern "C" }
#endif
#endif
