/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include "msgq.h"
#include "usbd_printer.h"


#define DEBUG_INFO

#define STATE_DEVICE_NO		0x00
#define STATE_DEVICE_CONN	0x02
#define STATE_DEVICE_READY	0x04
#define STATE_DEVICE_READ	0x08
#define STATE_DEVICE_WRITE	0x10
#define STATE_DEVICE_IDLE	0x20
#define STATE_POWER_FAULT	0x40

#define STATE_BUSY		0x0
#define STATE_USB_TX_CPLT	0x1

typedef struct env_s {
	msgq_t mq;
	volatile uint32_t flag;
	volatile uint8_t printer_status;
} env_t;

extern env_t env;
extern usbd_printer_dev_t printer_device;

extern void send_response_to_host(uint8_t *buf, uint32_t len);
#endif
