/**
  *********************************************************************************
  *
  * @file    flow.h
  * @brief   Header file for flow
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef   __FLOW_H__
#define   __FLOW_H__

#include "main.h"


extern int flow_send_msg_to_rx_msgq(void);
extern int flow_send_msg_to_tx_msgq(uint8_t *buf, uint32_t size);
extern ald_status_t flow_xor_check(uint8_t *buf, uint8_t len, uint8_t chk);
extern ald_status_t flow_xor_calc(uint8_t *buf, uint8_t len, uint8_t *chk);
extern int flow_init(void);

#endif
