/**
  *********************************************************************************
  *
  * @file    msgq.h
  * @brief   Header file for message queue
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MSGQ_H__
#define   __MSGQ_H__

#include "type.h"
#include "list.h"


#define MSG_POOL_SIZE	1000

typedef struct msgq_s {
	list_head_t list;
	uint32_t nr;
} msgq_t;

typedef struct msg_s {
	list_head_t link;

	uint8_t buf[64];
	uint32_t len;
} msg_t;

typedef struct msg_pool_s {
	list_head_t _free;
	uint32_t nr;
} msg_pool_t;


extern void msg_pool_init(void);
extern msg_t *msg_alloc(void);
extern void msg_free(msg_t *msg);
extern uint32_t msg_size_get(void);
extern void msgq_init(msgq_t * msgq);
extern void msgq_enq(msgq_t *msgq, msg_t *msg);
extern msg_t *msgq_deq(msgq_t *msgq);

#endif
