/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    17 Jul 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"
#include "usb_utils.h"


/** @addtogroup Projects_Examples_USB
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t tx_buf[512];
uint8_t rx_buf[512];
/**
  * @brief  Initializate pin of USB.
  * @retval None
  */
void usb_pin_init(void)
{
	gpio_init_t x;

	/* Initialize vbus pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_1;
	ald_gpio_init(GPIOB, GPIO_PIN_15, &x);
	ald_gpio_write_pin(GPIOB, GPIO_PIN_15, 1);

	return;
}

/**
  * @brief  Fill test package.
  * @retval None
  */
void test_buf_init()
{
	memset(tx_buf,      0x00, 9);
	memset(tx_buf + 9,  0xAA, 8);
	memset(tx_buf + 17, 0xEE, 8);
	memset(tx_buf + 25, 0xFE, 1);
	memset(tx_buf + 26, 0xFF, 11);

	tx_buf[37] = 0x7F;
	tx_buf[38] = 0xBF;
	tx_buf[39] = 0xDF;
	tx_buf[40] = 0xEF;
	tx_buf[41] = 0xF7;
	tx_buf[42] = 0xFB;
	tx_buf[43] = 0xFD;
	tx_buf[44] = 0xFC;
	tx_buf[45] = 0x7E;
	tx_buf[46] = 0xBF;
	tx_buf[47] = 0xDF;
	tx_buf[48] = 0xEF;
	tx_buf[49] = 0xF7;
	tx_buf[50] = 0xFB;
	tx_buf[51] = 0xFD;
	tx_buf[52] = 0x7E;

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{	
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);

	memset(tx_buf, 0x0, 512);
	memset(rx_buf, 0x0, 512);

	test_buf_init();
	uart_stdio_init();
	printf_e("System start...\n\r");

	ald_pmu_perh_power_config(PMU_POWER_USB, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_USB, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_usb_clock_config(CMU_USB_CLOCK_SEL_HOSC, CMU_USB_DIV_1);
	ald_rmu_reset_periperal(RMU_PERH_USB);
	ald_mcu_irq_config(USB_INT_IRQn, 2, 2, ENABLE);
	ald_mcu_irq_config(USB_DMA_IRQn, 2, 2, ENABLE);
	usb_pin_init();

	ald_usb_high_speed_enable(true);
	ald_usb_otg_session_request(true);
	ald_usb_eye_diagram_start(tx_buf, 53);

	while (1) {
		;
	}
}

/**
  * @}
  */
/**
  * @}
  */
