/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include <rtthread.h>
#include "main.h"


#define THREAD_STACK_SIZE	512
#define THREAD_PRIORITY		8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static struct rt_thread *tid1 = RT_NULL;
static struct rt_thread *tid2 = RT_NULL;
static struct rt_thread *tid3 = RT_NULL;
static struct rt_mutex *mutex = RT_NULL;


static void thread1_entry(void* parameter)
{
	rt_thread_delay(10);

	if (tid2->current_priority != tid3->current_priority)
		rt_kprintf("Test failed!\n");
	else
		rt_kprintf("Test success!\n");
}

static void thread2_entry(void* parameter)
{
	rt_thread_delay(5);

	while (1) {
		rt_mutex_take(mutex, RT_WAITING_FOREVER);
		rt_kprintf("Thread2 entry!\n");
		rt_mutex_release(mutex);
		rt_thread_delay(50);
	}
}

static void thread3_entry(void* parameter)
{
	rt_tick_t tick;

	while (1) {
		rt_mutex_take(mutex, RT_WAITING_FOREVER);

		tick = rt_tick_get();
		rt_kprintf("Thread1 entry!\n");
		while (rt_tick_get() - tick < 50) ;

		rt_mutex_release(mutex);
	}
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	mutex = rt_mutex_create("mutex", RT_IPC_FLAG_FIFO);
	if (mutex == RT_NULL)
		return 0;

	tid1 = rt_thread_create("t1", thread1_entry, RT_NULL,
				THREAD_STACK_SIZE, THREAD_PRIORITY - 1, 5);
	if (tid1 != RT_NULL)
		rt_thread_startup(tid1);

	tid2 = rt_thread_create("t2", thread2_entry, RT_NULL,
				THREAD_STACK_SIZE, THREAD_PRIORITY, 5);
	if (tid2 != RT_NULL)
		rt_thread_startup(tid2);
	
	tid3 = rt_thread_create("t3", thread3_entry, RT_NULL,
				THREAD_STACK_SIZE, THREAD_PRIORITY + 1, 5);
	if (tid3 != RT_NULL)
		rt_thread_startup(tid3);

	return 0;
}

/**
  * @}
  */
/**
  * @}
  */
