/**
  *********************************************************************************
  *
  * @file    board.h
  * @brief   Header file for board
  *
  * @version V1.0
  * @date    16 Sep 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#ifndef __BOARD_H__
#define __BOARD_H__

#define __SRAM_SIZE	96
#define __SRAM_END	(0x20000000 + __SRAM_SIZE * 1024)

#ifdef __CC_ARM
extern int Image$$RW_IRAM1$$ZI$$Limit;
#define HEAP_BEGIN  ((void *)&Image$$RW_IRAM1$$ZI$$Limit)
#elif __ICCARM__
#pragma section="HEAP"
#define HEAP_BEGIN  (__segment_end("HEAP"))
#else
extern int __bss_end;
#define HEAP_BEGIN  ((void *)&__bss_end)
#endif
#define HEAP_END    __SRAM_END

void rt_hw_board_init(void);
void rt_tick_handler(void);
#endif
