/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "demo.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
static void lv_test_roller_1(void);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
        lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	
	lv_test_roller_1();

	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Systick callback function
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}

/**
  * @brief  Roller display configuration
  * @retval None
  */
void lv_test_roller_1(void)
{
	static lv_style_t bg;
	
	/* Default object*/
	lv_obj_t * roller1 = lv_roller_create(lv_disp_get_scr_act(NULL), NULL);
	lv_obj_set_pos(roller1, 10, 10);
	
	lv_style_copy(&bg, &lv_style_pretty);
	bg.body.main_color = LV_COLOR_GRAY;
	bg.body.grad_color = LV_COLOR_WHITE;
	bg.body.shadow.width = 5;
	bg.text.line_space = 10;
	bg.text.opa = LV_OPA_60;
	bg.text.color = LV_COLOR_GRAY;

	lv_obj_t * roller2 = lv_roller_create(lv_disp_get_scr_act(NULL), NULL);
	lv_obj_set_size(roller2, 80, 120);
	lv_roller_set_options(roller2, "0\n1\n2\n3\n4\n5\n6\n7\n8\n9", true);
	lv_obj_align(roller2, roller1, LV_ALIGN_OUT_RIGHT_TOP, 20, 0);
	lv_roller_set_anim_time(roller2, 500);
	lv_roller_set_style(roller2, LV_ROLLER_STYLE_BG, &bg);
	lv_roller_set_style(roller2, LV_ROLLER_STYLE_SEL, &lv_style_plain);
	lv_roller_set_selected(roller2, 4, true);

	lv_obj_t * roller3 = lv_roller_create(lv_disp_get_scr_act(NULL), roller2);
	lv_obj_align(roller3, roller2, LV_ALIGN_OUT_RIGHT_TOP, 20, 0);
	lv_roller_set_fix_width(roller3, LV_DPI);
	lv_roller_set_align(roller3, LV_LABEL_ALIGN_RIGHT);
}

/**
  * @}
  */
/**
  * @}
  */
