/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
void lv_ex_win_1(void);				  

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	
	lv_ex_win_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Window display configuration
  * @retval None
  */
void lv_ex_win_1(void)
{
	/*Create a window*/
	lv_obj_t * win = lv_win_create(lv_scr_act(), NULL);
	lv_win_set_title(win, "Window title"); /*Set the title*/
	/*Add control button to the header*/
	lv_obj_t * close_btn = lv_win_add_btn(win, LV_SYMBOL_CLOSE); /*Add?
	,!close button and use built-in close action*/
	lv_obj_set_event_cb(close_btn, lv_win_close_event_cb);
	lv_win_add_btn(win, LV_SYMBOL_SETTINGS); /*Add a setup button*/
	/*Add some dummy content*/
	lv_obj_t * txt = lv_label_create(win, NULL);
	lv_label_set_text(txt, "This is the content of the window\n\n"
	"You can add control buttons to\n"
	"the window header\n\n"
	"The content area becomes automatically\n"
	"scrollable is it's large enough.\n\n"
	" You can scroll the content\n"
	"See the scroll bar on the right!");
}

/**
  * @brief  Systick callback function
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}

/**
  * @}
  */
/**
  * @}
  */
