/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * ddlist;
lv_obj_t *ta;

void lv_ex_ddlist_1(void);

/**
  * @brief  Draglist event callback handler
  * @param  obj: pointer to draglist object
  * @param  event: draglist event
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	if(event == LV_EVENT_VALUE_CHANGED) {
		char buf[32];
		lv_ddlist_get_selected_str(obj, buf, sizeof(buf));
		lv_ta_set_text(ta, buf);
	}
}
			  
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();

	lv_ex_ddlist_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Draglist display configuration
  * @retval None
  */
void lv_ex_ddlist_1(void)
{
	/*Create a drop down list*/
	ddlist = lv_ddlist_create(lv_scr_act(), NULL);
	lv_ddlist_set_options(ddlist, "Apple\n"
	"Banana\n"
	"Orange\n"
	"Melon\n"
	"Grape\n"
	"Raspberry");
	lv_ddlist_set_fix_width(ddlist, 100);
	lv_ddlist_set_draw_arrow(ddlist, true);
	lv_obj_align(ddlist, NULL, LV_ALIGN_IN_TOP_MID, 0, 200);
	lv_obj_set_event_cb(ddlist, event_handler);
	/*Create a text area. The keyboard will write here*/
	ta = lv_ta_create(lv_scr_act(), NULL);
	lv_obj_align(ta, NULL, LV_ALIGN_IN_TOP_MID, 0, 10);
	lv_obj_set_size(ta,200,100);
	lv_ta_set_text(ta, "");
}

/**
  * @brief  Systick callback bunction
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}

/**
  * @}
  */
/**
  * @}
  */
