/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "demo.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * btnm1 ;
lv_obj_t *ta;

/**
  * @brief  Button matrix callback handler
  * @param  obj: pointer to object
  * @param  event: button event
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	if(event == LV_EVENT_VALUE_CHANGED) {
	const char * txt = lv_btnm_get_active_btn_text(obj);
		lv_ta_add_text(ta, txt);
	}
}

static const char * btnm_map[] = {"1", "2", "3", "4", "5", "\n",
                                  "6", "7", "8", "9", "0", "\n",
                                  "Action1", "Action2", ""};
void lv_ex_btnm_1(void);
				  
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();

	lv_ex_btnm_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Button matrix display configuration
  * @retval None
  */
void lv_ex_btnm_1(void)
{
	btnm1 = lv_btnm_create(lv_scr_act(), NULL);
	lv_btnm_set_map(btnm1, btnm_map);
	lv_btnm_set_btn_width(btnm1, 10, 2); /*Make "Action1" twice as wide as
	,!"Action2"*/
	lv_obj_align(btnm1, NULL, LV_ALIGN_CENTER, 0, 0);
	lv_obj_set_event_cb(btnm1, event_handler);
	/*Create a text area. The keyboard will write here*/
	ta = lv_ta_create(lv_scr_act(), NULL);
	lv_obj_align(ta, NULL, LV_ALIGN_IN_TOP_MID, -100, 10);
	lv_obj_set_size(ta,400,200);
	lv_ta_set_text(ta, "");
}

/**
  * @brief  Systick callback function
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}


/**
  * @}
  */
/**
  * @}
  */
