/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * chart;
  


void lv_ex_kb_1(void);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	
	lv_ex_kb_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

void lv_ex_kb_1(void)
{
	/*Create styles for the keyboard*/
	static lv_style_t rel_style, pr_style;
	lv_style_copy(&rel_style, &lv_style_btn_rel);
	rel_style.body.radius = 0;
	rel_style.body.border.width = 1;
	lv_style_copy(&pr_style, &lv_style_btn_pr);
	pr_style.body.radius = 0;
	pr_style.body.border.width = 1;
	/*Create a keyboard and apply the styles*/
	lv_obj_t *kb = lv_kb_create(lv_scr_act(), NULL);
	lv_kb_set_cursor_manage(kb, true);
	lv_kb_set_style(kb, LV_KB_STYLE_BG, &lv_style_transp_tight);
	lv_kb_set_style(kb, LV_KB_STYLE_BTN_REL, &rel_style);
	lv_kb_set_style(kb, LV_KB_STYLE_BTN_PR, &pr_style);
	/*Create a text area. The keyboard will write here*/
	lv_obj_t *ta = lv_ta_create(lv_scr_act(), NULL);
	lv_obj_align(ta, NULL, LV_ALIGN_IN_TOP_MID, -100, 10);
	lv_obj_set_size(ta,400,200);
	lv_ta_set_text(ta, "");
	/*Assign the text area to the keyboard*/
	lv_kb_set_ta(kb, ta);
}

void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}


/**
  * @}
  */
/**
  * @}
  */
