/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * chart; 
void lv_ex_chart_1(void);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	lv_ex_chart_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Chart display configuration
  * @retval None
  */
void lv_ex_chart_1(void)
{
	/*Create a chart*/
	lv_obj_t * chart;
	chart = lv_chart_create(lv_scr_act(), NULL);
	lv_obj_set_size(chart, 250, 300);
	lv_obj_align(chart, NULL, LV_ALIGN_CENTER, 0, 0);
	lv_chart_set_type(chart, LV_CHART_TYPE_POINT | LV_CHART_TYPE_LINE); /*Show?
	,!lines and points too*/
	lv_chart_set_series_opa(chart, LV_OPA_70); /*Opacity?
	,!of the data series*/
	lv_chart_set_series_width(chart, 4); /*Line?
	,!width and point radious*/
	lv_chart_set_range(chart, 0, 100);
	/*Add two data series*/
	lv_chart_series_t * ser1 = lv_chart_add_series(chart, LV_COLOR_RED);
	lv_chart_series_t * ser2 = lv_chart_add_series(chart, LV_COLOR_GREEN);
	/*Set the next points on 'dl1'*/
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 10);
	lv_chart_set_next(chart, ser1, 30);
	lv_chart_set_next(chart, ser1, 70);
	lv_chart_set_next(chart, ser1, 90);
	/*Directly set points on 'dl2'*/
	ser2->points[0] = 90;
	ser2->points[1] = 70;
	ser2->points[2] = 65;
	ser2->points[3] = 65;
	ser2->points[4] = 65;
	ser2->points[5] = 65;
	ser2->points[6] = 65;
	ser2->points[7] = 65;
	ser2->points[8] = 65;
	ser2->points[9] = 65;
	lv_chart_refresh(chart); /*Required after direct set*/
}

/**
  * @brief  Systick callback function
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}


/**
  * @}
  */
/**
  * @}
  */
