/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "demo.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * slider1;
lv_obj_t * gauge1;
void lv_ex_gauge_1(void);
void lv_ex_slider_1(void);
static void event_handler(lv_obj_t * obj, lv_event_t event);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();	
	
	lv_ex_gauge_1();
	lv_ex_slider_1();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Gauge display configuration
  * @retval None
  */
void lv_ex_gauge_1(void)
{
	/*Create a style*/
	static lv_style_t style;
	lv_style_copy(&style, &lv_style_pretty_color);
	style.body.main_color = lv_color_hex3(0x666); /*Line color at the beginning*/
	style.body.grad_color = lv_color_hex3(0x666); /*Line color at the end*/
	style.body.padding.left = 10; /*Scale line length*/
	style.body.padding.inner = 8 ; /*Scale label padding*/
	style.body.border.color = lv_color_hex3(0x333); /*Needle middle circle color*/
	style.line.width = 3;
	style.text.color = lv_color_hex3(0x333);
	style.line.color = LV_COLOR_RED; /*Line color after the critical?,!value*/
	/*Describe the color for the needles {0x001F, 0xFD20, 0x8010} */
	static lv_color_t needle_colors[] = {0x001F, 0xFD20, 0x8010};//{LV_COLOR_BLUE, LV_COLOR_ORANGE, LV_COLOR_PURPLE};
	/*Create a gauge*/
	gauge1 = lv_gauge_create(lv_scr_act(), NULL);
	lv_gauge_set_style(gauge1, LV_GAUGE_STYLE_MAIN, &style);
	lv_gauge_set_needle_count(gauge1, 1, needle_colors);
	lv_obj_set_size(gauge1, 200, 200);
	lv_obj_align(gauge1, NULL, LV_ALIGN_CENTER, 0, -50);
	/*Set the values*/
	lv_gauge_set_value(gauge1, 0, 0);
}

/**
  * @brief  Slider display configuration
  * @retval None
  */
void lv_ex_slider_1(void)
{
	/*Create styles*/
	static lv_style_t style_bg;
	static lv_style_t style_indic;
	static lv_style_t style_knob;
	lv_style_copy(&style_bg, &lv_style_pretty);
	style_bg.body.main_color = LV_COLOR_BLACK;
	style_bg.body.grad_color = LV_COLOR_GRAY;
	style_bg.body.radius = LV_RADIUS_CIRCLE;
	style_bg.body.border.color = LV_COLOR_WHITE;
	lv_style_copy(&style_indic, &lv_style_pretty_color);
	style_indic.body.radius = LV_RADIUS_CIRCLE;
	style_indic.body.shadow.width = 8;
	style_indic.body.shadow.color = style_indic.body.main_color;
	style_indic.body.padding.left = 3;
	style_indic.body.padding.right = 3;
	style_indic.body.padding.top = 3;
	style_indic.body.padding.bottom = 3;
	lv_style_copy(&style_knob, &lv_style_pretty);
	style_knob.body.radius = LV_RADIUS_CIRCLE;
	style_knob.body.opa = LV_OPA_70;
	style_knob.body.padding.top = 10 ;
	style_knob.body.padding.bottom = 10 ;
	/*Create a slider*/
	slider1 = lv_slider_create(lv_scr_act(), NULL);
	lv_slider_set_style(slider1, LV_SLIDER_STYLE_BG, &style_bg);
	lv_slider_set_style(slider1, LV_SLIDER_STYLE_INDIC,&style_indic);
	lv_slider_set_style(slider1, LV_SLIDER_STYLE_KNOB, &style_knob);
	lv_obj_align(slider1, NULL, LV_ALIGN_CENTER, -20, 150);
	lv_obj_set_event_cb(slider1, event_handler);
	
	lv_slider_set_range(slider1, 0, 100);
	lv_obj_set_size(slider1, 250, 40);
}

/**
  * @brief  Slider callback handler
  * @param  obj: pointer to slider 
  * @param  event: slider event 
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	int16_t tmp = 0;
	if(event == LV_EVENT_VALUE_CHANGED) {
		tmp = lv_slider_get_value(slider1);
		lv_gauge_set_value(gauge1,0,tmp);
	}
}

/**
  * @brief  Systick callback function
  * @retval None
  */
 void ald_systick_irq_cbk(void)
 {
	lv_tick_inc(1);
 }

/**
  * @}
  */
/**
  * @}
  */
