/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "demo.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
  
lv_obj_t * led1;
lv_obj_t * btn1;
void lv_ex_led(void);
void lv_ex_button(void);

/**
  * @brief  Button press event callback function
  * @param  btn: pointer to button
  * @param  event: button event  
  * @retval None
  */
void btn_event_cb(lv_obj_t * btn, lv_event_t event)
{
	switch(event) {
		case LV_EVENT_PRESSED:
			lv_led_toggle(led1);	
			break;
		default:		
			break;
	}
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
	
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_EBI, ENABLE);
	ald_cmu_perh_clock_config(CMU_PERH_ALL,ENABLE);
	
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();	
	
	lv_ex_button();
	lv_ex_led();
	while(1) {
		ald_delay_ms(10);
		lv_task_handler();
	}
}

/**
  * @brief  Button display configuration  
  * @retval None
  */
void lv_ex_button(void)
{
	btn1 = lv_btn_create(lv_scr_act(), NULL); /*Add a button the current screen*/
	lv_obj_align(btn1, NULL, LV_ALIGN_CENTER,0, 0);
	lv_obj_set_size(btn1, 100, 50); /*Set its size*/
	lv_obj_set_event_cb(btn1, btn_event_cb); /*Assign a callback to the button*/
	lv_obj_t * label = lv_label_create(btn1, NULL); /*Add a label to the button*/
	lv_label_set_text(label, "Button1"); /*Set the labels text*/
}

/**
  * @brief  LED display configuration  
  * @retval None
  */
void lv_ex_led(void)
{
	/*Create a style for the LED*/
	static lv_style_t style_led;
	
	lv_style_copy(&style_led, &lv_style_pretty_color);
	style_led.body.radius = LV_RADIUS_CIRCLE;
	style_led.body.main_color = LV_COLOR_MAKE(0xb5, 0x0f, 0x04);
	style_led.body.grad_color = LV_COLOR_MAKE(0x50, 0x07, 0x02);
	style_led.body.border.color = LV_COLOR_MAKE(0xfa, 0x0f, 0x00);
	style_led.body.border.width = 3;
	style_led.body.border.opa = LV_OPA_30;
	style_led.body.shadow.color = LV_COLOR_MAKE(0xb5, 0x0f, 0x04);
	style_led.body.shadow.width = 5;
	/*Create a LED and switch it ON*/
	 led1 = lv_led_create(lv_scr_act(), NULL);
	lv_obj_set_style(led1, &style_led);
	lv_obj_align(led1, NULL, LV_ALIGN_CENTER, 0, -150);
	lv_led_off(led1);
}

/**
  * @brief  Systick callback function 
  * @retval None
  */
void ald_systick_irq_cbk(void)
{
	lv_tick_inc(1);
}

/**
  * @}
  */
/**
  * @}
  */
