/**
  *********************************************************************************
  *
  * @file    bsp_led.h
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#ifndef __BSP_LED_H__
#define __BSP_LED_H__

#include "ald_conf.h"

#ifdef _cplusplus
extern "C" {
#endif
/** @addtogroup ES32F3xxx_BSP
  * @{
  */
  
/** @addtogroup LED
  * @{
  */
  
/** @defgroup LED_Private_Macros LED Private Macros
  * @{
  */
#define BSP_LED_MAX	2

#define GPIO_PORT_LED1	  GPIOF
#define GPIO_PIN_LED1     GPIO_PIN_0
#define GPIO_PORT_LED2	  GPIOF
#define GPIO_PIN_LED2     GPIO_PIN_1

/**
  * @}
  */
/** @addtogroup LED_Public_Functions
  * @{
  */
void bsp_led_init(void);
void bsp_led_on(uint8_t num);
void bsp_led_off(uint8_t num);
void bsp_led_toggle(uint8_t num);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
