/**
  **************************************************************************************
  * @file    bootloader.h
  * @brief   bootloader head file.
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __APP_UPDATE_H__
#define __APP_UPDATE_H__  

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
#include "ald_iap.h"
#include "es32f36xx.h"  

extern uint32_t boot_complete;

#define APP_FLASH_START_ADDRESS             (0x000008000U)
#define APP_FLASH_SIZE                      (0x000070000U)

uint8_t application_check_and_run(void);
uint8_t app_flash_erase(void);
uint8_t app_flash_write(uint32_t addr, const uint8_t *data, uint32_t data_length);
void app_flash_info(uint32_t *start_addr, uint32_t *size);

#ifdef __cplusplus
}
#endif
#endif
