/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "md_conf.h"

#define UART0_TX_PORT   GPIOB
#define UART0_TX_PIN    MD_GPIO_PIN_10
#define UART0_RX_PORT   GPIOB
#define UART0_RX_PIN    MD_GPIO_PIN_11

/**
  * @brief  UART handle structure definition
  */
typedef struct uart_handle_s
{
    uint8_t *tx_buf;    /**< Pointer to UART Tx transfer Buffer */
    uint16_t tx_size;   /**< UART Tx Transfer size */
    uint16_t tx_count;  /**< UART Tx Transfer Counter */
    uint8_t *rx_buf;    /**< Pointer to UART Rx transfer Buffer */
    uint16_t rx_size;   /**< UART Rx Transfer size */
    uint16_t rx_count;  /**< UART Rx Transfer Counter */

} md_uart_handle_t;

extern void md_dma0_irq_handler(UART_TypeDef *UARTx);

#endif
