/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "md_utils.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  AD16C4T0 IRQ handler
  * @retval None
  */
void AD16C4T0_UP_Handler(void)
{
    static uint16_t cnt = 0;

    /* Handle TIM interrupt */
    if (md_timer_get_update_valid_interrupt_flag_uei(AD16C4T0) == 1)
    {
        md_timer_clear_update_interrupt_flag_ueic(AD16C4T0);
        cnt++;

        if (!(cnt % 50))
            md_gpio_toggle_pin_output(LED_GPIO_PORT, LED_GPIO_PIN);
    }
}

/**
  * @brief  AD16C4T0 IRQ handler
  * @retval None
  */
void AD16C4T0_CC_Handler(void)
{
    if (md_timer_get_cc1_valid_interrupt_flag_ch1cci(AD16C4T0))
        md_timer_clear_cc1_interrupt_flag_ch1ccic(AD16C4T0);

    if (md_timer_get_cc2_valid_interrupt_flag_ch2cci(AD16C4T0))
        md_timer_clear_cc2_interrupt_flag_ch2ccic(AD16C4T0);

    if (md_timer_get_cc3_valid_interrupt_flag_ch3cci(AD16C4T0))
        md_timer_clear_cc3_interrupt_flag_ch3ccic(AD16C4T0);

}


/**
  * @}
  */
/**
  * @}
  */
