/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

md_rtc_time_t time;
md_rtc_date_t date;
md_rtc_alarm_t alarm;

/**
  * @brief  RTC IRQ handler
  * @retval None
  */
void rtc_irq_handler(void)
{
    md_rtc_get_time(&time, MD_RTC_FORMAT_DEC);
    md_rtc_is_active_flag_alma();
    md_rtc_clear_flag_alma();

    return;
}
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    md_rtc_init_t init;

    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(5);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();
    /* Set PCLK2 frequency */
    md_cmu_div_config(MD_CMU_PCLK_2, MD_CMU_DIV_4);

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* Enable RTC interrupt */
    md_mcu_irq_config(RTC_IRQn, 0, 3, ENABLE);

    /* Initialize RTC */
    init.asynch_pre_div  = 0;
    init.synch_pre_div   = 32767;
    init.hour_format     = MD_RTC_HOUR_FORMAT_24;
    init.output          = MD_RTC_ALARMOUT_DISABLE;
    init.output_polarity = MD_RTC_OUTPUT_POLARITY_HIGH;
    md_rtc_init(&init);

    /* Set current time and date */
    time.hour    = 13;
    time.minute  = 9;
    time.second  = 38;
    date.day     = 7;
    date.month   = 5;
    date.year    = 24;
    date.week    = 2;
    md_rtc_set_time(&time, MD_RTC_FORMAT_DEC);
    md_rtc_set_date(&date, MD_RTC_FORMAT_DEC);

    /* Set alarm */
    alarm.day          = 7;
    alarm.idx          = MD_RTC_ALARM_A;
    alarm.mask         = MD_RTC_ALARM_MASK_NONE;
    alarm.sel          = MD_RTC_SELECT_DAY;
    alarm.ss_mask      = MD_RTC_ALARM_SS_MASK_ALL;
    alarm.time.hour    = 13;
    alarm.time.minute  = 9;
    alarm.time.second  = 40;
    alarm.time.sub_sec = 123;
    md_rtc_set_alarm(&alarm, MD_RTC_FORMAT_DEC);

    /* Enable alarm-a interrupt */
    md_rtc_enable_alma_intrrupt();

    while (1)
    {
        /* Get time/date each second */
        md_delay_1ms(1000);
        md_rtc_get_time(&time, MD_RTC_FORMAT_DEC);

    }
}

/**
  * @}
  */
/**
  * @}
  */
