/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    while (1);
}

/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART0_Handler(void)
{
    /* Handle uart interrupt */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}
/**
  * @brief  GPIO handler
  * @retval None
  */
void EXTI2_Handler(void)
{
    md_exti2_iqr_handler();

}
/**
  * @brief  LVD handler
  * @retval None
  */
void LVD_Handler(void)
{
    md_lvd_iqr_handler();

}

/**
  * @}
  */
/**
  * @}
  */
