/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

#define TEST_ADDR   (300 * 1024)
#define TEST_LEN    32

uint8_t write[TEST_LEN];
uint8_t read[TEST_LEN];
uint32_t i = 0;
int ret = 0;
uint8_t cflash_flag = 0;
uint8_t dflash_flag = 0;

/**
  * @brief  Initializate pin.
  * @retval None
  */
void gpio_pin_init(void)
{
    md_gpio_init_t x;

    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA, MD_GPIO_PIN_15, &x);
    md_gpio_init(GPIOC, MD_GPIO_PIN_12, &x);
    MD_GPIOA_SET_PIN(MD_GPIO_PIN_15);
    MD_GPIOC_SET_PIN(MD_GPIO_PIN_12);
}
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint8_t *addr = (uint8_t *)(uint32_t)TEST_ADDR;
    
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    /* Enable ALL peripheral clock */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* GPIO init */
    gpio_pin_init();
    /* Initialize 1ms tick */
    md_init_1ms_tick();
    
    /* Initialize buffer */
    memset(write, 0x55, TEST_LEN);
    memset(read, 0x00, TEST_LEN);    
    /* Erase flash */
    md_msc_erase_page(TEST_ADDR);
    /* Write data to flash */
    md_msc_program_words(TEST_ADDR, write, TEST_LEN, 0);
    /* Read data from the flash address */
    for (i = 0; i < TEST_LEN; ++ i)
        read[i] = addr[i];
    
    ret = memcmp(write, read, TEST_LEN);
    
    if (!ret)
    {
        cflash_flag = 1;
    }

    /* Initialize buffer */
    memset(write, 0xAA, TEST_LEN);
    memset(read, 0x00, TEST_LEN);
    /* Erase flash */
    md_msc_erase_page_df(TEST_ADDR);
    /* Write data to flash */
    md_msc_program_words_df(TEST_ADDR, write, TEST_LEN, 0);

    /* Read data from the flash address */
    for (i = 0; i < TEST_LEN; ++ i)
        read[i] = addr[i];
    
    ret = memcmp(write, read, TEST_LEN);
    
    if (!ret)
    {
        dflash_flag = 1;
    }
    
    while (1)
    {
        if (cflash_flag)
        {
            MD_GPIOA_TOGGLE_PIN(MD_GPIO_PIN_15);
        }
        
        if (dflash_flag)
        {
            MD_GPIOC_TOGGLE_PIN(MD_GPIO_PIN_12);
        }
        md_delay_1ms(300);
    }
}
/**
  * @}
  */
/**
  * @}
  */
