/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

#define TEST_ADDR   (40 * 1024)
#define TEST_LEN    32

uint8_t write[TEST_LEN];
uint8_t read[TEST_LEN];

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    uint32_t i;
    uint8_t *addr = (uint8_t *)(uint32_t)TEST_ADDR;

    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);

    /* Initialize 1ms tick */
    md_init_1ms_tick();

    /* Initialize buffer */
    memset(write, 0x55, TEST_LEN);
    memset(read, 0x00, TEST_LEN);

    /* Erase flash */
    md_msc_erase_page(TEST_ADDR);

    /* Write data to flash */
    md_msc_program_words(TEST_ADDR, write, TEST_LEN, 0);

    /* Read data from the flash address */
    for (i = 0; i < TEST_LEN; ++ i)
        read[i] = addr[i];

    /* Erase flash */
    md_msc_erase_page(TEST_ADDR);

    /* Read data from the flash address*/
    for (i = 0; i < TEST_LEN; ++ i)
        read[i] = addr[i];

    /*  */
    while (1)
    {
        md_delay_1ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
