/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "md_conf.h"
#define MD_LPUART_ERROR_NONE 0x00U  /**< No error */
#define MD_LPUART_ERROR_PE   0x01U  /**< Parity error */
#define MD_LPUART_ERROR_NE   0x02U  /**< Noise error */
#define MD_LPUART_ERROR_FE   0x04U  /**< frame error */
#define MD_LPUART_ERROR_ORE  0x08U  /**< Overrun error */
#define MD_LPUART_ERROR_DMA  0x10U  /**< DMA transfer error */
/**
  * @brief  LPUART handle structure definition
  */
typedef struct lpuart_handle_s
{
    uint8_t *tx_buf;    /**< Pointer to LPUART Tx transfer Buffer */
    uint16_t tx_size;   /**< LPUART Tx Transfer size */
    uint16_t tx_count;  /**< LPUART Tx Transfer Counter */
    uint8_t *rx_buf;    /**< Pointer to LPUART Rx transfer Buffer */
    uint16_t rx_size;   /**< LPUART Rx Transfer size */
    uint16_t rx_count;  /**< LPUART Rx Transfer Counter */

} md_lpuart_handle_t;
extern void md_lpuart_irq_handler(LPUART_TypeDef *LPUARTx);
#endif
