/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t flag = 0;
uint32_t cnt = 0;

/**
  * @brief  Initialize pin
  * @retval None
  */
void pin_init(void)
{
    md_gpio_init_t x;

    /* Initialize pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_2;
    md_gpio_init(GPIOC, MD_GPIO_PIN_5, &x);

    /* Initialize pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_TTL;
    x.func  = MD_GPIO_FUNC_1;
    md_gpio_init(GPIOA, MD_GPIO_PIN_15, &x);
}

/**
  * @brief  This is main function
  * @retval Status
  */

int main()
{
    md_lptim_init_t init;

    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(5);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize pin */
    pin_init();
    /* Enable LP16T0 interrupt */
    md_mcu_irq_config(LP16T0_IRQn, 3, 1, ENABLE);
    /* Set LP16T0 clock source */
    SYSCFG_UNLOCK();
    md_cmu_set_lptim0_clock_source(0x5);
    SYSCFG_LOCK();

    init.psc  = MD_LPTIM_PRESC_4;
    init.arr  = 0xFFF;
    init.mode = MD_LPTIM_MODE_CONTINUOUS;
    md_lptim_base_init(LPTIM, &init);

    md_lptim_set_output_state(LPTIM, 0x01);
    md_lptim_set_clock_source(LPTIM, 0x0);
    md_lptim_set_clock_edge(LPTIM, 0x0);
    md_lptim_set_trigger_polarity(LPTIM, 0x0);
    md_lptim_set_trigger_source(LPTIM, 0x0);

    /* Enable ARR interrupt */
    md_lptim_enable_arrmie_intrrupt(LPTIM);
    /* Start LPTIM0 */
    md_lptim_enable(LPTIM);

    while (READ_BIT(LPTIM->SYNCSTAT, LP16T_SYNCSTAT_CON1WBSY_MSK));

    md_lptim_set_continuous_mode(LPTIM);

    while (READ_BIT(LPTIM->SYNCSTAT, LP16T_SYNCSTAT_CON1WBSY_MSK));

    while (1)
    {
        if (flag)
        {
            MD_GPIOA_TOGGLE_PIN(MD_GPIO_PIN_15);
            flag = 0;
            ++cnt;
        }
    }
}
/**
  * @}
  */
/**
  * @}
  */
