/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "md_conf.h"

#define SLAVE_ADDR   0xA0
/**
  * @brief  I2C handle Structure definition
  */
typedef struct md_i2c_handle_s
{
    uint8_t *p_buff;          /**< Pointer to I2C transfer buffer */
    uint16_t xfer_size;       /**< I2C transfer size */
    uint16_t xfer_count;      /**< I2C transfer counter */
} md_i2c_handle_t;

extern void md_i2c_ev_irq_handler(I2C_TypeDef *I2Cx);
extern void md_i2c_er_irq_handler(I2C_TypeDef *I2Cx);
#endif
