/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

uint32_t __value;
md_dac_init_t h_dac;
md_dma_config_t config;
md_timer_base_init_t tim_init;
const uint16_t sine_wave128[] =
{
    2047, 2147, 2248, 2347, 2446, 2544, 2641, 2737, 2830, 2922, 3012, 3099,
    3184, 3266, 3346, 3422, 3494, 3564, 3629, 3691, 3749, 3803, 3852, 3897,
    3938, 3974, 4006, 4033, 4055, 4072, 4084, 4092, 4094, 4092, 4084, 4072,
    4055, 4033, 4006, 3974, 3938, 3897, 3852, 3803, 3749, 3691, 3629, 3564,
    3494, 3422, 3346, 3266, 3184, 3099, 3012, 2922, 2830, 2737, 2641, 2544,
    2446, 2347, 2248, 2147, 2047, 1947, 1846, 1747, 1648, 1550, 1453, 1357,
    1264, 1172, 1082, 995, 910, 828, 748, 672, 600, 530, 465, 403,
    345, 291, 242, 197, 156, 120, 88, 61, 39, 22, 10, 2,
    0, 2, 10, 22, 39, 61, 88, 120, 156, 197, 242, 291,
    345, 403, 465, 530, 600, 672, 748, 828, 910, 995, 1082, 1172,
    1264, 1357, 1453, 1550, 1648, 1747, 1846, 1947
};

/**
  * @brief  Initializate pin of dac module.
  * @retval None
  */
void dac_pin_init(void)
{
    md_gpio_init_t x;

    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;
    md_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN, &x);

    return;
}

/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize dac pin */
    dac_pin_init();

    /* Initialize DAC0 */
    md_dac_struct_init(&h_dac);
    h_dac.soft_trig   = MD_DAC_WR_DBUF_TRG;
    h_dac.noise_mode  = MD_DAC_NWM_TRINOISE;
    h_dac.noise_width = MD_DAC_NWBW_12;
    h_dac.output_gpio = ENABLE;
    h_dac.align_mode  = MD_DAC_ALIGN_R12;
    md_dac_init(&h_dac);

    /* DMA config */
    memset(&config, 0x0, sizeof(md_dma_config_t));
    md_dma_config_struct(&config);
    config.R_power        = MD_DMA_R_POWER_2;
    config.mem_to_mem     = DISABLE;
    config.channel        = 0;
    config.dst_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    config.dst_inc        = MD_DMA_DATA_INC_DISABLE;
    config.src_inc        = MD_DMA_DATA_INC_ENABLE;
    config.src_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    config.src            = (void *)&sine_wave128;
    config.dst            = (void *)&DAC0->R12BUF;
    config.size           = 128;
    config.msel           = MD_DMA_MSEL_TIMER2;
    config.msigsel        = MD_DMA_MSIGSEL_TIMER_UPDATE;
    config.dir            = MD_DMA_DIR_TO_PERH;
    config.circle_mode    = ENABLE;
    md_dma_init(DMA0, 0, &config);
    md_adc_converter_enable_adcen(ADC0);
    md_dma_enable_channel(DMA0, 0);
    md_adc_dma_enable(ADC0);

    /* Initialize GP32C4T0 */
    md_timer_base_struct_init(&tim_init);
    tim_init.prescaler = 47999;
    tim_init.period    = 1;
    md_timer_base_set_config(GP32C4T0, &tim_init);
    md_timer_enable_udma(GP32C4T0);
    md_timer_enable_counter_cnten(GP32C4T0);
    md_timer_master_trgout_sel_trgosel(GP32C4T0, MD_TIMER_TRGO_UPDATE);

    while (1)
    {

    }
}
/**
  * @}
  */
/**
  * @}
  */
