/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

uint32_t __value;
md_dac_init_t h_dac;

/**
  * @brief  Initializate pin of dac module.
  * @retval None
  */
void dac_pin_init(void)
{
    md_gpio_init_t x;

    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;
    md_gpio_init(DAC0_OUT_PORT, DAC0_OUT_PIN, &x);

    return;
}

/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize dac pin */
    dac_pin_init();

    /* Initialize DAC0 */
    md_dac_struct_init(&h_dac);
    md_dac_init(&h_dac);

    while (1)
    {
        md_delay_1ms(300);
        __value  = __value < 200 ? 4095 : __value;
        __value -= 200;
        md_dac_set_conv_r12value(DAC0, __value);
    }
}
/**
  * @}
  */
/**
  * @}
  */
