/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include <string.h>
#include "main.h"
#include "md_calc.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
uint32_t result;






/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config_default();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* Calculate Square root,result is 16 */
    result = md_calc_sqrt(256);
    /* Calculate Square root,result is 88 */
    result = md_calc_sqrt(7744);

    while (1)
    {
        md_delay_1ms(1000);

    }
}

/**
  * @}
  */
/**
  * @}
  */
