/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

uint32_t nm_value, in_value;
md_adc_init_t h_adc;
md_adc_nch_conf_t n_config;
uint16_t vdd_val = 0U;

/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize ADC0 */
    md_adc_struct_init(&h_adc);
    md_adc_normal_struct_init(&n_config);
    n_config.ch = MD_ADC_CHANNEL_16;
    md_adc_init(ADC0, &h_adc);
    md_adc_normal_channel_config(ADC0, &n_config);

    while (1)
    {
        /* Start normal convert */
        md_adc_set_normal_channel_conv_start_nchtrg(ADC0);

        while (md_adc_get_stat_nche(ADC0) == 0);

        md_adc_set_clr_nche(ADC0);
        nm_value = md_adc_get_normal_channel_val(ADC0);
        vdd_val = VREF * 4095 / nm_value;
        md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */
