/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

uint32_t nm_value;
uint8_t nor_flag;
md_adc_init_t h_adc;
md_adc_nch_conf_t n_config;
md_dma_config_t config;
uint16_t dst[5];

/**
  * @brief  Initializate pin of adc module.
  * @retval None
  */
void adc_pin_init(void)
{
    md_gpio_init_t x;

    /* Initialize sck pin */
    x.mode  = MD_GPIO_MODE_INPUT;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;

    md_gpio_init(GPIO_CH0_PORT, ADC_CH0_PIN, &x);
    md_gpio_init(GPIO_CH2_PORT, ADC_CH2_PIN, &x);
    md_gpio_init(GPIO_CH3_PORT, ADC_CH3_PIN, &x);
    md_gpio_init(GPIO_CH9_PORT, ADC_CH9_PIN, &x);
    md_gpio_init(GPIO_CH10_PORT, ADC_CH10_PIN, &x);
}

/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    NVIC_SetPriority(DMA0_IRQn, 2U);
    NVIC_EnableIRQ(DMA0_IRQn);

    md_mcu_irq_config(DMA0_IRQn, 1, 1, ENABLE);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize adc pin */
    adc_pin_init();

    /* Initialize ADC0 */
    md_adc_struct_init(&h_adc);
    h_adc.nch_nr = MD_ADC_NCH_NR_5;
    md_adc_init(ADC0, &h_adc);

    /* ADC channel config */
    n_config.ch   = MD_ADC_CHANNEL_0;
    n_config.idx  = MD_ADC_NCH_IDX_1;
    n_config.samp = MD_ADC_SAMPLETIME_4;
    md_adc_normal_channel_config(ADC0, &n_config);

    n_config.ch   = MD_ADC_CHANNEL_2;
    n_config.idx  = MD_ADC_NCH_IDX_2;
    n_config.samp = MD_ADC_SAMPLETIME_4;
    md_adc_normal_channel_config(ADC0, &n_config);

    n_config.ch   = MD_ADC_CHANNEL_3;
    n_config.idx  = MD_ADC_NCH_IDX_3;
    n_config.samp = MD_ADC_SAMPLETIME_4;
    md_adc_normal_channel_config(ADC0, &n_config);

    n_config.ch   = MD_ADC_CHANNEL_9;
    n_config.idx  = MD_ADC_NCH_IDX_4;
    n_config.samp = MD_ADC_SAMPLETIME_4;
    md_adc_normal_channel_config(ADC0, &n_config);

    n_config.ch   = MD_ADC_CHANNEL_10;
    n_config.idx  = MD_ADC_NCH_IDX_5;
    n_config.samp = MD_ADC_SAMPLETIME_4;
    md_adc_normal_channel_config(ADC0, &n_config);

    /* DMA config */
    memset(&config, 0x0, sizeof(md_dma_config_t));
    md_dma_config_struct(&config);
    config.mem_to_mem     = DISABLE;
    config.channel        = 0;
    config.dst_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    config.dst_inc        = MD_DMA_DATA_INC_ENABLE;
    config.src_inc        = MD_DMA_DATA_INC_DISABLE;
    config.src_data_width = MD_DMA_DATA_SIZE_HALFWORD;
    config.src            = (void *)&ADC0->NCHDR;
    config.dst            = (void *)&dst;
    config.size           = 5;
    config.msel           = MD_DMA_MSEL_ADC0;
    config.msigsel        = MD_DMA_MSIGSEL_ADC;
    config.dir            = MD_DMA_DIR_TO_SRAM;
    config.circle_mode    = ENABLE;
    md_dma_init(DMA0, 0, &config);
    MD_ADC_ENABLE(ADC0);
    md_dma_enable_channel(DMA0, 0);
    md_adc_dma_enable(ADC0);
    /* Enable DMA0 channel 0 TC interrupt */
    md_dma_enable_it_tc(DMA0, 0);
    md_adc_set_normal_channel_conv_start_nchtrg(ADC0);

    while (1)
    {
        if (0x1 == nor_flag)
        {
            nor_flag = 0x0;
            /* ADC trigger */
            md_adc_set_normal_channel_conv_start_nchtrg(ADC0);
        }

    }
}

/**
  * @}
  */
/**
  * @}
  */
