/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

uint32_t nm_value, in_value;
uint8_t nor_flag, ins_flag;
md_adc_init_t h_adc;
md_adc_nch_conf_t n_config;
md_adc_ich_conf_t i_config;

/**
  * @brief  Initializate pin of adc module.
  * @retval None
  */
void adc_pin_init(void)
{
    md_gpio_init_t x;

    /* Initialize sck pin */
    x.mode  = MD_GPIO_MODE_INPUT;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;
    md_gpio_init(GPIO_CH0_PORT, ADC_CH0_PIN, &x);

    x.mode  = MD_GPIO_MODE_INPUT;
    x.pupd  = MD_GPIO_PUSH_UP;
    x.podrv = MD_GPIO_OUT_DRIVE_1;
    x.nodrv = MD_GPIO_OUT_DRIVE_1;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;
    md_gpio_init(GPIO_CH2_PORT, ADC_CH2_PIN, &x);


    return;
}

/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HRC, MD_CMU_PLL_OUTPUT_48M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 48000000);
    /* PriorityGroup_2 */
    NVIC_SetPriorityGrouping(2);
    /* Enable adc interrupt */
    md_mcu_irq_config(ADC0_IRQn, 1, 1, ENABLE);

    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Initialize adc pin */
    adc_pin_init();

    /* Initialize ADC0 */
    md_adc_struct_init(&h_adc);
    md_adc_normal_struct_init(&n_config);
    md_adc_init(ADC0, &h_adc);
    md_adc_normal_channel_config(ADC0, &n_config);
    md_adc_insert_struct_init(&i_config);
    md_adc_insert_channel_config(ADC0, &i_config);

    /* Enable normal interrupt */
    md_adc_conv_end_interrupt_enable_ncheie(ADC0);

    /* Enable insert interrupt */
    md_adc_inserted_channel_interrupt_enable_icheie(ADC0);

    while (1)
    {
        md_adc_set_normal_channel_conv_start_nchtrg(ADC0);
        md_delay_1ms(10);

        /* Get normal convert */
        if (nor_flag == 0x1)
        {
            nor_flag = 0;
            nm_value = md_adc_get_normal_channel_val(ADC0);
        }

        /* Get insert convert */
        md_adc_set_inserted_channel_conv_start_ichtrg(ADC0);
        md_delay_1ms(10);

        if (ins_flag == 0x1)
        {
            ins_flag = 0;
            in_value = md_adc_get_insert_channel1_val(ADC0);
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */
