/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
ald_timer_handle_t h_tim;
ald_timer_clock_config_t clock;
ald_timer_slave_config_t slave_init;

/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void timer_pin_init(void)
{
    ald_gpio_init_t x;

    x.mode  = ALD_GPIO_MODE_INPUT;
    x.pupd  = ALD_GPIO_PUSH_DOWN;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_TTL;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(GPIOB, GPIO_PIN_6, &x);
}


/**
  * @brief  Main function
  * @retval Status
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    /* Initialize pin and set the default state*/
    timer_pin_init();

    /* Initialize GP16C4T0 */
    h_tim.perh           = GP16C4T0;
    h_tim.init.prescaler = 0;
    h_tim.init.mode      = ALD_TIMER_CNT_MODE_UP;
    h_tim.init.period    = 0xFFFF;
    h_tim.init.clk_div   = ALD_TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt    = 0;
    h_tim.capture_cbk    = NULL;
    ald_timer_base_init(&h_tim);

    /* Initialize clock source */
    clock.source     = ALD_TIMER_SRC_INTER;
    clock.psc        = ALD_TIMER_ETR_PSC_DIV1;
    clock.polarity   = ALD_TIMER_CLK_POLARITY_RISE;
    clock.filter     = 0;
    ald_timer_config_clock_source(&h_tim, &clock);

    slave_init.mode     = ALD_TIMER_MODE_TRIG;
    slave_init.input    = ALD_TIMER_TS_TI1FP1;
    slave_init.polarity = ALD_TIMER_CLK_POLARITY_RISE;
    slave_init.psc      = ALD_TIMER_ETR_PSC_DIV1;
    slave_init.filter   = 1;
    ald_timer_slave_config_sync(&h_tim, &slave_init);

    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
