/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
ald_timer_handle_t h_tim;
ald_timer_clock_config_t clock;
ald_timer_one_pulse_init_t init;

/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void timer_pin_init(void)
{
    ald_gpio_init_t x;

    /* Initialize tim0 ch1 pin */
    x.mode  = ALD_GPIO_MODE_OUTPUT;
    x.odos  = ALD_GPIO_PUSH_PULL;
    x.pupd  = ALD_GPIO_PUSH_UP;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_TTL;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(TIMER0_PULSE_PORT, TIMER0_PULSE_PIN, &x);

    x.mode  = ALD_GPIO_MODE_INPUT;
    x.pupd  = ALD_GPIO_PUSH_DOWN;
    x.flt   = ALD_GPIO_FILTER_DISABLE;
    x.type  = ALD_GPIO_TYPE_TTL;
    x.nodrv = ALD_GPIO_OUT_DRIVE_1;
    x.podrv = ALD_GPIO_OUT_DRIVE_1;
    x.func  = ALD_GPIO_FUNC_2;
    ald_gpio_init(TIMER0_TRIGGER_PORT, TIMER0_TRIGGER_PIN, &x);
}


/**
  * @brief  Main function
  * @retval Status
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    ald_cmu_pll_config(ALD_CMU_PLL_INPUT_HRC, ALD_CMU_PLL_OUTPUT_48M);
    ald_cmu_clock_config(ALD_CMU_CLOCK_PLL, 48000000);
    ald_cmu_perh_clock_config(ALD_CMU_PERH_ALL, ENABLE);
    /* Initialize pin and set default state */
    timer_pin_init();

    /* Initialize AD16C4T0 */
    h_tim.perh           = AD16C4T0;
    h_tim.init.prescaler = 0;
    h_tim.init.mode      = ALD_TIMER_CNT_MODE_UP;
    h_tim.init.period    = 65535;
    h_tim.init.clk_div   = ALD_TIMER_CLOCK_DIV1;
    h_tim.init.re_cnt    = 0;
    ald_timer_one_pulse_init(&h_tim, ALD_TIMER_OP_MODE_REPEAT);

    /* Initialize clock source */
    clock.source = ALD_TIMER_SRC_INTER;
    ald_timer_config_clock_source(&h_tim, &clock);

    /* Config one pulse channel */
    init.mode        = ALD_TIMER_OC_MODE_PWM2;
    init.pulse       = 16383;
    init.oc_polarity = ALD_TIMER_OC_POLARITY_HIGH;
    init.polarity    = ALD_TIMER_IC_POLARITY_RISE;
    init.sel         = ALD_TIMER_IC_SEL_DIRECT;
    init.filter      = 0;
    ald_timer_one_pulse_config_channel(&h_tim, &init, ALD_TIMER_CHANNEL_1, ALD_TIMER_CHANNEL_2);

    /* start one pulse */
    ald_timer_one_pulse_start(&h_tim, ALD_TIMER_OP_OUTPUT_CHANNEL_1);

    /* Stop one pulse */
    while (1)
    {
        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
