/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "utils.h"
#include "ald_dma.h"
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    ald_inc_tick();
    return;
}

/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA0_Handler(void)
{
    uint32_t  reg = DMA0->IFM;
        
    if (reg & 0x1)
    {
        DMA0->ICR = 0x1;
        
        /* SPI RXO */
        SPI0->CON1  &=~ (0x1 << 10);        
        /* CS SET */
        FLASH_CS_SET();
        /* CHANNEL DISABLE */
        DMA0->CH[0].CON &=~0x1;
        /* SPI RX DMA DISABLE */
        SPI0->CON2  &= ~0x1;
        
        lcd_refresh_status++;
    }    
}

/**
  * @brief  Uart0 handler
  * @retval None
  */
void UART0_Handler(void)
{
    ald_uart_irq_handler(&h_uart);
    return;
}

/**
  * @brief  GPIO handler
  * @retval None
  */
void EXTI2_Handler(void)
{
    if (EXTI->EXTIFLAG & 0x4)
    {
        EXTI->EXTICFR = 0x4;
        g_key_trig = 0x1;
    }
}

/**
  * @brief  GP16C4T0 handler
  * @retval None
  */
void GP16C4T0_Handler(void)
{
    uint32_t reg = GP16C4T0->IFM;
    
    /* TIMER Update event */
    if (READ_BIT(reg, ALD_TIMER_FLAG_UPDATE))
    {
        GP16C4T0->ICR = ALD_TIMER_FLAG_UPDATE;
        pic_refresh_flag = 0x1;
    }
}

/**
  * @}
  */
/**
  * @}
  */
