/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    9 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

#include "main.h"



/* Includes ------------------------------------------------------------------ */
/* Exported Types ------------------------------------------------------------ */

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05
#define FLASH_READ_FAST     0x0C

/* Exported Macros ----------------------------------------------------------- */

#define FLASH_CS_SET() ALD_GPIOA_SET_PIN(GPIO_PIN_4)
#define FLASH_CS_CLR() ALD_GPIOA_RESET_PIN(GPIO_PIN_4)

typedef enum flash_status_s
{
    FLASH_OK    = 0,
    FLASH_ERROR = 1,
} flash_status_t;

extern void flash_module_init(void);
extern flash_status_t flash_read(uint32_t addr, uint8_t *buf, uint32_t size);
extern flash_status_t flash_write(uint32_t addr, uint8_t *buf, uint16_t size);
extern flash_status_t flash_sector_erase(uint32_t addr);
extern flash_status_t flash_wait_unbusy(void);
extern uint32_t flash_read_id(void);
extern flash_status_t flash_chip_erase(void);

#endif    /*__FLASH_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
