/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    12 Mar 2024
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Mar 2024     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include "lcd.h"
#include "string.h"
#include "stdint.h"
#include "spi_flash.h"

#define PIC_SIZE       (320*240*2)
#define PIC_INC        (320*240*2)
#define PIC_NUM        7
#define PIC_FPS        14

enum lcd_refresh_status_t
{
    idle = 0,
    first_in_transfer = 1,
    first_complete = 2,
    second_in_transfer = 3,
    second_complete = 4,
    third_in_transfer = 5,
    third_complete = 6,
    four_in_transfer = 7,
    four_complete = 8
};


extern ald_uart_handle_t h_uart;
extern ald_spi_handle_t h_spi;
extern uint8_t g_key_trig;
extern uint8_t g_key_erase ;
extern ald_spi_handle_t h_spi1;

extern uint8_t pic_refresh_flag;
extern enum lcd_refresh_status_t lcd_refresh_status;



#endif
