#ifndef __LCD_H
#define __LCD_H

#include "main.h"

#define USE_HORIZONTAL 2  //设置横屏或者竖屏显示 0或1为竖屏 2或3为横屏

/*******设置默认清屏颜色*********/
#define Color_Clear WHITE

/* 定义英文字符大小   */
typedef enum{LCD_Char12x24=0, LCD_Char16x32} LCD_CharSize;

// 定义屏幕的大小
#define Width   240 // 宽度,x轴
#define Height  320 // 高度,y轴




//画笔颜色
#define WHITE         	 0xFFFF
#define BLACK         	 0x0000	  
#define BLUE           	 0x001F  
#define BRED             0XF81F
#define GRED 			 0XFFE0
#define GBLUE			 0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define YELLOW        	 0xFFE0
#define BROWN 			 0xBC40 //棕色
#define BRRED 			 0xFC07 //棕红色
#define GRAY  			 0x8430 //灰色
#define DARKBLUE      	 0x01CF	//深蓝色
#define LIGHTBLUE      	 0x7D7C	//浅蓝色  
#define GRAYBLUE       	 0x5458 //灰蓝色
#define LIGHTGREEN     	 0x841F //浅绿色
#define LGRAY 			 0xC618 //浅灰色(PANNEL),窗体背景色
#define LGRAYBLUE        0xA651 //浅灰蓝色(中间层颜色)
#define LBBLUE           0x2B12 //浅棕蓝色(选择条目的反色)

/* 引脚设置函数 */
// 写数据/命令
#define LCD_DC_Set()   do{ ald_gpio_write_pin(GPIOC,GPIO_PIN_8,1); }while(0)
#define LCD_DC_Clr()    do{ ald_gpio_write_pin(GPIOC,GPIO_PIN_8,0); }while(0)
// 使能和失能背光
#define LCD_BLK_Set()   do{ ald_gpio_write_pin(GPIOA,GPIO_PIN_10,1); }while(0)
#define LCD_BLK_Clr() do{ ald_gpio_write_pin(GPIOA,GPIO_PIN_10,0); }while(0)
// 复位设置
#define LCD_RES_Set()   do{ ald_gpio_write_pin(GPIOA,GPIO_PIN_9,1); }while(0)
#define LCD_RES_Clr() do{ ald_gpio_write_pin(GPIOA,GPIO_PIN_9,0); }while(0)
// 片选使能和失能
#define LCD_CS_Set()    do{ ald_gpio_write_pin(GPIOB,GPIO_PIN_12,1); }while(0)
#define LCD_CS_Clr()  do{ ald_gpio_write_pin(GPIOB,GPIO_PIN_12,0); }while(0)






//-----------------LCD端口定义---------------- 

void LCD_Writ_Bus(uint8_t dat);//模拟SPI时序
void LCD_WR_DATA8(uint8_t dat);//写入一个字节
void LCD_WR_DATA(uint16_t dat);//写入两个字节
void LCD_WR_REG(uint8_t dat);  //写入一个指令
void LCD_Address_Set(uint16_t x1,uint16_t y1,uint16_t x2,uint16_t y2);//设置坐标函数

void LCD_Fill(uint16_t xsta,uint16_t ysta,uint16_t xend,uint16_t yend,uint16_t color);//指定区域填充颜色
void LCD_DrawPoint(uint16_t x,uint16_t y,uint16_t color);                             //在指定位置画一个点
void LCD_DrawLine(uint16_t x1,uint16_t y1,uint16_t x2,uint16_t y2,uint16_t color);    //在指定位置画一条线
void LCD_DrawRectangle(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2,uint16_t color);//在指定位置画一个矩形
void Draw_Circle(uint16_t x0,uint16_t y0,uint8_t r,uint16_t color);//在指定位置画一个圆
void LCD_ShowPicture(uint16_t x,uint16_t y,uint16_t length,uint16_t width,const uint8_t pic[]);//显示图片

void LCD_Init(void);//LCD初始化


#endif




